/*  Sucht die schnelleste Abarbeitung (Terminierung) für eine gegebene ABK und Such-ID-Kombination und gibt das gefundene Ergebnis
    als Tabelle mit Einträgen für die Resource-Timeline-Tabelle zurück.

    Die Konstante _time_penalty beeinflusst die Reihnfolge der schnellsten Terminierungsergebnisse.
    Pro weitere noch nicht vorher genutzen Arbeitsplatzressource in aktuellen Pfad wird diese Zeitstrafe zum aktuellen Abarbeitungsdauer dazugerechnet.
    Pfade mit den wenigsten unterschiedlichen Arbeitspaltzressourcen, also möglichst immer die gleichen Kostenstellen werden bevorzugt. */
SELECT tsystem.function__drop_by_regex( 'resource_termination_results__abk__fastest_fetch', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_termination_results__abk__fastest_fetch(
      _abk_ix     integer,
      _search_id  integer
  ) RETURNS TABLE  (
      _ab2_id             integer,
      _resource_id        integer,
      _slotStartDate      timestamp,
      _slotEndDate        timestamp,
      _slotType           scheduling.resource_timeline_blocktype,
      _slotFactor         numeric(16,6),
      _usage              numeric(12,8),
      _top_resource_id    integer,
      _top_slotStartDate  timestamp,
      _top_slotEndDate    timestamp,
      _top_slotType       scheduling.resource_timeline_blocktype,
      _top_slotFactor     numeric(16,6),
      _top_usage          numeric(12,8)
  ) AS $$

  DECLARE

      _time_penalty CONSTANT interval := interval '3 days'; -- Zeitstrafe pro Hinzufügen einer weiteren noch nicht vorher genutzten Arbeitsplatzressource im aktuellen Ressourcenpfad.

  BEGIN

      -- RAISE NOTICE '%',format( 'scheduling.resource_termination_results__abk__fastest_fetch(%L,%L)', _abk_ix, _search_id );

      RETURN QUERY
        WITH
            fastest AS (
                SELECT *
                  FROM scheduling.resource_termination_results
                 WHERE
                       abk_ab_ix = _abk_ix
                   AND search_id = _search_id
                 ORDER BY
                       -- Sortiert nach schnellster Durchlaufzeit. Dafür werden pro weitere Kostenstelle 3 Tage virtuelle Kosten aufgeschlagen. Damit wird der Pfad der kürzer ist (also auf gleichen Kostenstellen läuft und nicht wechselt) bevorzugt
                       (date_end - date_start) + ( ( array_length( array_unique(resource_id_path), 1) ) * _time_penalty ) ASC,
                       -- bei gleichem Ende-Datum nehmen wir den kürzesten Pfad. Das ist der mit den wenigsten unterschiedlichen Resourcen, also möglichst immer die gleiche Kostenstelle
                       array_length( array_unique(resource_id_path), 1) ASC,
                       resource_id_path ASC
                 LIMIT 1
            ),

            extracted AS (
                SELECT
                    unnest( resource_id_path )       AS resource_id,
                    unnest( resource_vertices_path ) AS vert_id,
                    unnest( ab2_a2_id_path )         AS ab2_a2_id,
                    unnest( ab2_termination_result ) AS t
                FROM fastest
            )

        SELECT
            ab2_a2_id,
            resource_id,
            ((jsonb_array_elements (t))->>'slotstartdate')::timestamp AS slotStartDate,
            ((jsonb_array_elements (t))->>'slotenddate')::timestamp,
            ((jsonb_array_elements (t))->>'slottype')::scheduling.resource_timeline_blocktype,
            ((jsonb_array_elements (t))->>'slotfactor')::numeric,
            ((jsonb_array_elements (t))->>'usage')::numeric,
            ((jsonb_array_elements (t))->>'top_resource_id')::integer,
            ((jsonb_array_elements (t))->>'top_slotstartdate')::timestamp,
            ((jsonb_array_elements (t))->>'top_slotenddate')::timestamp,
            ((jsonb_array_elements (t))->>'top_slottype')::scheduling.resource_timeline_blocktype,
            ((jsonb_array_elements (t))->>'top_slotfactor')::numeric,
            ((jsonb_array_elements (t))->>'top_usage')::numeric
        FROM extracted
        ORDER BY slotStartDate;

    END $$ LANGUAGE plpgsql;